//
//  AppDelegate.m
//  ApplinkDemo
//
//  Created by muhuai on 15/8/28.
//  Copyright (c) 2015年 MuHuai. All rights reserved.
//

#import "AppDelegate.h"
#import <TBAppLinkSDK/TBAppLinkSDK.h>
#import "NativeController.h"
#import "WebViewController.h"
@interface AppDelegate ()

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    //1.初始化SDK
    [TBAppLinkSDK initWithAppkey:@"23082328" BackURL:@"TBAppLinkDemo://" pid:@"pid_test" type:@"type_test"];
    
    //2.设置加密相关信息,:
    
    [[TBAppLinkSDK sharedInstance] setAppSecret:@"6bc7db53673216213ae374fc1d5b30a4"];
    
    //3.设置 未安装手淘或者手淘版本不支持时的 降级方案
    //有三种:(1)调到手淘下载页 (默认)              TBAppLinkJumpFailedModeDownLoadTaobao
    //      (2)降级到H5页面                TBAppLinkJumpFailedModeOpenH5
    //      (3)SDK不做处理,开发者可以自行处理 TBAppLinkJumpFailedModeNone
    [[TBAppLinkSDK sharedInstance] setJumpFailedMode:TBAppLinkJumpFailedModeOpenH5]; //设置跳转失败的处理方式
    
    
    
    //5.注册JSBridge,两种方式
    //(1)
    [TBAppLinkSDK setupUIWebViewForAppLinkJsSDK];
    
    //(2) 
    //setWebView:(id)webView withDelegate:(id<UIWebViewDelegate>)delegate;
    
    
    UITabBarController *controller = [[UITabBarController alloc] init];
    NativeController *nativeController = [[NativeController alloc] init];
    nativeController.tabBarItem.title = @"native调用";
    [controller addChildViewController:nativeController];
    
    WebViewController *webviewController = [[WebViewController alloc] init];
    webviewController.tabBarItem.title = @"JS调用";
    [controller addChildViewController:webviewController];

    

    [_window setBackgroundColor:[UIColor whiteColor]];
    _window.rootViewController = controller;
    [_window makeKeyAndVisible];
    // Override point for customization after application launch.
    return YES;
}


-(BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url
{
    //回跳后的处理
    if ([[TBAppLinkSDK sharedInstance] handleOpenURL:url]) {
        return YES;
    }else{
        //do your job
    }
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

@end
