//
//  ViewController.m
//  ApplinkDemo
//
//  Created by muhuai on 15/8/28.
//  Copyright (c) 2015年 MuHuai. All rights reserved.
//

#import "NativeController.h"
#import <TBAppLinkSDK/TBAppLinkSDK.h>

@interface NativeController ()<UITextFieldDelegate>

@property (nonatomic, strong) UILabel     *centralParamLabel;
@property (nonatomic, strong) UILabel     *eLabel;;
@property (nonatomic, strong) UILabel     *backURLLabel;

@property (nonatomic, strong) UITextField *centralParamField;
@property (nonatomic, strong) UITextField *eField;
@property (nonatomic, strong) UITextField *backURLField;

@property (nonatomic, strong) UIButton    *jumpButton;

@property (nonatomic, strong) UISegmentedControl *segmentedControl;


@end

@implementation NativeController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tabBarItem.title = @"native";
    [self initView];
    
    // Do any additional setup after loading the view, typically from a nib.
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


    //更新label
- (void)segmentedControlAction:(id)sender {
    switch ([sender selectedSegmentIndex]) {
        case 0:
            _centralParamLabel.text        = @"shopId:";
            _centralParamField.enabled     = YES;
            _centralParamField.placeholder = @"必须为数字";
            _eField.enabled                = YES;
            break;
        case 1:
            _centralParamLabel.text        = @"itemId:";
            _centralParamField.enabled     = YES;
            _centralParamField.placeholder = @"必须为数字";
            _eField.enabled                = YES;
            break;
        case 2:
            _centralParamLabel.text        = @"h5URL:";
            _centralParamField.enabled     = YES;
            _centralParamField.placeholder = @"必须为URL格式";
            _eField.enabled                = YES;
            break;
        case 3:
            _centralParamLabel.text        = @"";
            _centralParamField.text        = nil;
            _centralParamField.enabled     = NO;
            _centralParamField.placeholder = @"无需参数";
            _eField.enabled                = NO;
            break;
        default:
            NSLog(@"AA");
            break;
    }

}

        //跳转,如param中设置了e,type,backURL,则会忽略SDK中的值
- (void)ClickBtn:(id)sender {
    switch (_segmentedControl.selectedSegmentIndex) {
        case 0: //shop
        {
            NSString *shopId   = _centralParamField.text;; //只能为数字
            TBShopParam *param = [[TBShopParam alloc] initWithShopId:shopId];
            param.e            = @"e";
            param.backURL        = _backURLField.text;
            [[TBAppLinkSDK sharedInstance] jumpShop:param];
            break;
        }
        case 1: //detail
        {
            NSString *itemId     = _centralParamField.text;
            TBDetailParam *param = [[TBDetailParam alloc] initWithItemId:itemId];
            param.e              = _eField.text;
            param.backURL        = _backURLField.text;            
            [[TBAppLinkSDK sharedInstance] jumpDetail:param];
            break;
        }
        case 2: //URI
        {
            NSString *uri = _centralParamField.text;
            TBURIParam  *param = [[TBURIParam alloc] initWithURI:uri];
            param.e            = _eField.text;
            param.backURL      = _backURLField.text;
            [[TBAppLinkSDK sharedInstance] jumpTBURI:param];
            break;
        }
        case 3://授权
        {
            TBAuthParam *param = [[TBAuthParam alloc] initWithRedirectURI:@"http://tmshow.play.jaeapp.com"];
            [[TBAppLinkSDK sharedInstance] doAuth:param  Complete:^(NSError *error, NSDictionary *dic) {
                //授权成功的回调
                UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"doAuth" message:dic.description delegate:nil cancelButtonTitle:@"ok" otherButtonTitles:nil];
                [alertView show];
            }];
            break;
        }
        default:
            break;
    }
}


- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [textField resignFirstResponder];
    return YES;
}
- (void)initView {
    CGSize size         = self.view.frame.size;
    CGFloat width       = size.width;
    CGFloat leftMargin  = 50;
    CGFloat TopMargin   = 20;
    CGFloat labelWidth  = 80;
    CGFloat labelHeight = 30;
    CGFloat fieldWidth  = width - leftMargin * 2 -labelWidth;
    CGFloat fieldHeight = 30;
    
    _centralParamLabel = [[UILabel alloc] initWithFrame:CGRectMake(leftMargin, 90, labelWidth, labelHeight)];
    _centralParamLabel.text = @"shopId";
    [self.view addSubview:_centralParamLabel];
    
    _centralParamField = [[UITextField alloc] initWithFrame:CGRectMake(leftMargin + labelWidth, 90, fieldWidth, fieldHeight)];
    _centralParamField.borderStyle   = UITextBorderStyleRoundedRect;
    _centralParamField.returnKeyType = UIReturnKeyDone;
    _centralParamField.delegate      = self;
    _centralParamField.placeholder   = @"必须为数字";
    [self.view addSubview:_centralParamField];
    
    _eLabel = [[UILabel alloc] initWithFrame:CGRectMake(leftMargin, _centralParamLabel.frame.origin.y + labelHeight + TopMargin, labelWidth, labelHeight)];
    _eLabel.text = @"e:";
    [self.view addSubview:_eLabel];
    
    _eField = [[UITextField alloc] initWithFrame:CGRectMake(leftMargin + labelWidth, _eLabel.frame.origin.y , fieldWidth, fieldHeight)];
    _eField.borderStyle   = UITextBorderStyleRoundedRect;
    _eField.returnKeyType = UIReturnKeyDone;
    _eField.delegate      = self;
    //    _eField.placeholder   = @"e,type为";
    [self.view addSubview:_eField];
    
    
    _backURLLabel = [[UILabel alloc] initWithFrame:CGRectMake(leftMargin, _eLabel.frame.origin.y + labelHeight + TopMargin, labelWidth, labelHeight)];
    _backURLLabel.text = @"backURL:";
    [self.view addSubview:_backURLLabel];
    
    _backURLField = [[UITextField alloc] initWithFrame:CGRectMake(leftMargin + labelWidth, _backURLLabel.frame.origin.y, fieldWidth, fieldHeight)];
    _backURLField.borderStyle   = UITextBorderStyleRoundedRect;
    _backURLField.returnKeyType = UIReturnKeyDone;
    _backURLField.delegate      = self;
    _backURLField.placeholder   = @"例如:TBApplinkDemo://";
    [self.view addSubview:_backURLField];
    
    
    
    
    _segmentedControl = [[UISegmentedControl alloc] initWithItems:@[@"jumpShop",@"jumpDetail",@"jumpH5",@"doAuth"]];
    _segmentedControl.frame = CGRectMake(10, 50, width - 20 , 30);
    [_segmentedControl addTarget:self action:@selector(segmentedControlAction:) forControlEvents:UIControlEventValueChanged];
    _segmentedControl.selectedSegmentIndex = 0;
    [self.view addSubview:_segmentedControl];
    
    _jumpButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    _jumpButton.frame = CGRectMake(100, _backURLLabel.frame.origin.y + labelHeight, width - 100 - 100, labelHeight);
    [_jumpButton setTitle:@"Click Me" forState:UIControlStateNormal];
    [_jumpButton addTarget:self action:@selector(ClickBtn:) forControlEvents:UIControlEventTouchDown];
    [self.view addSubview:_jumpButton];
    
    
    
}

@end
