//
//  WebViewController.m
//  ApplinkDemo
//
//  Created by muhuai on 15/8/29.
//  Copyright (c) 2015年 MuHuai. All rights reserved.
//

#import "WebViewController.h"

@interface WebViewController ()

@property (nonatomic, strong) UIWebView *webview;

@end

@implementation WebViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    _webview = [[UIWebView alloc] initWithFrame:self.view.frame];
    //[_webview loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:@"http://wapp.m.taobao.com/act/wopsdk.html?spm=0.0.0.0.l1MDfK&host=%20h5.m.taobao.com"]]];

    NSString *path = [[NSBundle mainBundle] pathForResource:@"tida-ext-demo" ofType:@"html"];
    NSURL *url = [NSURL fileURLWithPath:path];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    [_webview loadRequest:request];
    
    [self.view addSubview:_webview];
    
    
    UIFont* font = [UIFont fontWithName:@"HelveticaNeue" size:12.0];
    
    UIButton *messageButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    [messageButton setTitle:@"reload webview" forState:UIControlStateNormal];
    [messageButton addTarget:self action:@selector(reloadWebView:) forControlEvents:UIControlEventTouchUpInside];
    [self.view insertSubview:messageButton aboveSubview:_webview];
    messageButton.frame = CGRectMake(10, 414, 100, 35);
    messageButton.titleLabel.font = font;
    messageButton.backgroundColor = [UIColor colorWithWhite:1 alpha:0.75];
    
}

- (void)reloadWebView:(id)sender {
    
    [_webview reload];

}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
